/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client;

import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.script.ConsoleLine;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.LogType;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.awt.Desktop;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_8494;
import org.jetbrains.annotations.Nullable;

public class KubeJSErrorScreen
extends class_437 {
    public final class_437 lastScreen;
    public final ScriptType scriptType;
    public final Path logFile;
    public final List<ConsoleLine> errors;
    public final List<ConsoleLine> warnings;
    public List<ConsoleLine> viewing;
    private ErrorList list;

    public KubeJSErrorScreen(class_437 lastScreen, ScriptType scriptType, @Nullable Path logFile, List<ConsoleLine> errors, List<ConsoleLine> warnings) {
        super((class_2561)class_2561.method_43473());
        this.lastScreen = lastScreen;
        this.scriptType = scriptType;
        this.logFile = logFile;
        this.errors = errors;
        this.warnings = warnings;
        this.viewing = errors.isEmpty() && !warnings.isEmpty() ? warnings : errors;
    }

    public KubeJSErrorScreen(class_437 lastScreen, ConsoleJS console) {
        this(lastScreen, console.scriptType, console.scriptType.getLogFile(), new ArrayList<ConsoleLine>(console.errors), new ArrayList<ConsoleLine>(console.warnings));
    }

    public class_2561 method_25435() {
        return class_2561.method_43470((String)("There were KubeJS " + this.scriptType.name + " errors!"));
    }

    protected void method_25426() {
        super.method_25426();
        this.list = new ErrorList(this, this.field_22787, this.field_22789, this.field_22790, 32, this.field_22790 - 32, this.viewing);
        this.method_25429((class_364)this.list);
        int i = this.field_22790 - 26;
        if (CommonProperties.get().startupErrorReportUrl.isBlank()) {
            openLog = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Open Log File"), this::openLog).method_46434(this.field_22789 / 2 - 155, i, 150, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.scriptType.isStartup() ? "Quit" : "Close")), this::quit).method_46434(this.field_22789 / 2 - 155 + 160, i, 150, 20).method_46431());
        } else {
            openLog = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Open Log File"), this::openLog).method_46434(this.field_22789 / 4 - 55, i, 100, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Report"), this::report).method_46434(this.field_22789 / 2 - 50, i, 100, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.scriptType.isStartup() ? "Quit" : "Close")), this::quit).method_46434(this.field_22789 * 3 / 4 - 45, i, 100, 20).method_46431());
        }
        openLog.field_22763 = this.logFile != null;
        class_4185 viewOther = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.viewing == this.errors ? "View Warnings [" + this.warnings.size() + "]" : "View Errors [" + this.errors.size() + "]")), this::viewOther).method_46434(this.field_22789 - 107, 7, 100, 20).method_46431());
        if (this.errors.isEmpty() || this.warnings.isEmpty()) {
            viewOther.field_22763 = false;
        }
    }

    private void quit(class_4185 button) {
        if (this.scriptType.isStartup()) {
            this.field_22787.method_1592();
        } else {
            this.method_25419();
        }
    }

    private void report(class_4185 button) {
        this.method_25430(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11749, CommonProperties.get().startupErrorReportUrl)));
    }

    private void openLog(class_4185 button) {
        if (this.logFile != null) {
            this.method_25430(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11746, this.logFile.toAbsolutePath().toString())));
        }
    }

    private void viewOther(class_4185 button) {
        this.viewing = this.viewing == this.errors ? this.warnings : this.errors;
        this.method_48640();
    }

    public void method_25394(class_332 guiGraphics, int mx, int my, float delta) {
        this.method_25420(guiGraphics);
        this.list.method_25394(guiGraphics, mx, my, delta);
        guiGraphics.method_25300(this.field_22793, "KubeJS " + this.scriptType.name + " script " + (this.viewing == this.errors ? "errors" : "warnings"), this.field_22789 / 2, 12, 0xFFFFFF);
        super.method_25394(guiGraphics, mx, my, delta);
    }

    public boolean method_25422() {
        return !this.scriptType.isStartup();
    }

    public void method_25419() {
        this.field_22787.method_1507(this.lastScreen);
    }

    public static class ErrorList
    extends class_4280<Entry> {
        public final KubeJSErrorScreen screen;
        public final List<ConsoleLine> lines;

        public ErrorList(KubeJSErrorScreen screen, class_310 minecraft, int x1, int height, int y0, int y1, List<ConsoleLine> lines) {
            super(minecraft, x1, height, y0, y1, 48);
            this.screen = screen;
            this.lines = lines;
            this.method_31322(false);
            Calendar calendar = Calendar.getInstance();
            for (int i = 0; i < lines.size(); ++i) {
                this.method_25321((class_350.class_351)new Entry(this, minecraft, i, lines.get(i), calendar));
            }
        }

        public boolean method_25404(int i, int j, int k) {
            Entry sel;
            if (class_8494.method_51255((int)i) && (sel = (Entry)this.method_25334()) != null) {
                sel.open();
                return true;
            }
            return super.method_25404(i, j, k);
        }

        public int method_25322() {
            return (int)((double)this.field_22742 * 0.93);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Entry
    extends class_4280.class_4281<Entry> {
        private final ErrorList errorList;
        private final class_310 minecraft;
        private final ConsoleLine line;
        private long lastClickTime;
        private final class_5481 indexText;
        private final class_5481 scriptLineText;
        private final class_5481 timestampText;
        private final List<class_5481> errorText;
        private final List<class_5481> stackTraceText;

        public Entry(ErrorList errorList, class_310 minecraft, int index, ConsoleLine line, Calendar calendar) {
            this.errorList = errorList;
            this.minecraft = minecraft;
            this.line = line;
            this.indexText = class_2561.method_43470((String)("#" + (index + 1))).method_30937();
            ArrayList<ConsoleLine.SourceLine> sourceLines = new ArrayList<ConsoleLine.SourceLine>(line.sourceLines);
            Collections.reverse(sourceLines);
            this.scriptLineText = class_2561.method_43470((String)sourceLines.stream().map(Object::toString).map(s -> s.isEmpty() ? (this.line.type == LogType.WARN ? "Internal Warning" : "Internal Error") : s).collect(Collectors.joining(" -> "))).method_30937();
            StringBuilder sb = new StringBuilder();
            calendar.setTimeInMillis(line.timestamp);
            UtilsJS.appendTimestamp(sb, calendar);
            this.timestampText = class_2561.method_43470((String)sb.toString()).method_30937();
            this.errorText = new ArrayList<class_5481>(minecraft.field_1772.method_1728((class_5348)class_2561.method_43470((String)line.message), errorList.method_25322()).stream().limit(3L).toList());
            this.stackTraceText = line.stackTrace.isEmpty() ? List.of() : minecraft.field_1772.method_1728((class_5348)class_2561.method_43470((String)String.join((CharSequence)"\n", line.stackTrace)).method_10862(class_2583.field_24360.method_10977(class_124.field_1080)), Integer.MAX_VALUE);
        }

        public class_2561 method_37006() {
            return class_2561.method_43473();
        }

        public void method_25343(class_332 g, int idx, int y, int x, int w, int h, int mx, int my, boolean hovered, float delta) {
            int col = this.line.type == LogType.ERROR ? 16735075 : 0xFFBB5B;
            g.method_35720(this.minecraft.field_1772, this.indexText, x + 1, y + 1, col);
            g.method_35719(this.minecraft.field_1772, this.scriptLineText, x + w / 2, y + 1, 0xFFFFFF);
            g.method_35720(this.minecraft.field_1772, this.timestampText, x + w - this.minecraft.field_1772.method_30880(this.timestampText) - 4, y + 1, 0x666666);
            for (int i = 0; i < this.errorText.size(); ++i) {
                g.method_35720(this.minecraft.field_1772, this.errorText.get(i), x + 1, y + 13 + i * 10, col);
            }
            if (hovered && !this.stackTraceText.isEmpty()) {
                this.errorList.screen.method_47414(class_437.method_25442() ? this.stackTraceText : this.stackTraceText.stream().limit(4L).toList());
            }
        }

        public boolean method_25402(double d, double e, int i) {
            this.errorList.method_25313((class_350.class_351)this);
            if (class_156.method_658() - this.lastClickTime < 250L) {
                if (i == 1) {
                    this.minecraft.field_1774.method_1455(String.join((CharSequence)"\n", this.line.stackTrace));
                } else {
                    this.open();
                }
                return true;
            }
            this.lastClickTime = class_156.method_658();
            return true;
        }

        public void open() {
            Path path;
            Object object = this.line.externalFile == null ? (this.line.sourceLines.isEmpty() || this.line.sourceLines.iterator().next().source().isEmpty() ? null : this.line.console.scriptType.path.resolve(this.line.sourceLines.iterator().next().source())) : (path = this.line.externalFile);
            if (path != null && Files.exists(path, new LinkOption[0])) {
                try {
                    if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.BROWSE_FILE_DIR)) {
                        throw new IllegalStateException("Error");
                    }
                    Desktop.getDesktop().browseFileDirectory(path.toFile());
                }
                catch (Exception ignored) {
                    if (Files.isRegularFile(path, new LinkOption[0]) && !path.getFileName().toString().endsWith(".js")) {
                        path = path.getParent();
                    }
                    this.errorList.screen.method_25430(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11746, path.toAbsolutePath().toString())));
                }
            }
        }
    }
}

